/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	SetPartTitle.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

//  Set the specified title to active part 
HRESULT SetPartTitle(CString titleName)
{

	START_METHOD("SetPartTitle")

	HRESULT status = CONV_SUCCESS;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	// get active doc.. here it is partdocument
	IDispatch *pActiveDoc = NULL;
	status = pdApplication->GetActiveDoc(&pActiveDoc);
	CHECK_RETURN_STATUS(status)

	IPartDocument * activePart = CAST(IPartDocument, pActiveDoc);

	IDispatch *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	IObject *object = CAST(IObject, pDesign);

	IDispatch *pFile = NULL;
	status = object->GetFile(&pFile);
	CHECK_RETURN_STATUS(status)

	IObjectFile *objectFile = CAST(IObjectFile, pFile);

	BSTR tname = titleName.AllocSysString(); 
	status = objectFile->SetTitle(tname);
	CHECK_RETURN_STATUS(status)

	END_METHOD("SetPartTitle")
}
